//
// CaloPLANES.cc -- standalone program to call the CaloPLANES macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/11/07)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TString.h>
#include <caloclasses.h>
#include <iostream>
//
extern void CaloPLANES(TString, TString, TString, int,  int, int, TString, TString);
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString outdir;
  TString figty;
  TString parity;
  TString view;
  int plane;
  int fromevent;
  int toevent;
  if ( numinp != 9 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
    };
    printf("\nUsage:\n\n CaloPLANES file view parity plane fromevent toevent outDir figformat \n");
    printf("\n - file                must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
    printf(  " - view                can be both, x or y\n");
    printf(  " - parity              can be both, odd or even \n");
    printf(  " - plane               plane number [1,11], 0 = all \n");
    printf(  " - fromevent           first event to process (progressive number), 0 = first \n");
    printf(  " - toevent             last event to process (progressive number), 0 = last \n");
    printf(  " - outDir              directory where to save figures\n");
    printf(  " - figformat           format to save figures (eps,ps,root,...) \n");
    printf("\nExample: \n\nCaloPLANES /home/pamela/filesfromyoda/dw_050301_00100/ both both 0 0 0 /home/pamela/ ps \n\n");
    return(0);
    //
  } else {
    printf("\n Welcome to CaloPLANES! \n");
    name = (TString)inps[1];
    view = (TString)inps[2];
    parity = (TString)inps[3];
    plane = atoi(inps[4]);
    fromevent = atoi(inps[5]);
    toevent = atoi(inps[6]);
    outdir = (TString)inps[7];
    figty = (TString)inps[8];
  };
  //
  CaloPLANES(name,view,parity,plane,fromevent,toevent,outdir,figty);
  //
  return(0);
}
